/******************************************************************************/
/* Vector Redirection FILE FOR MSPBoot Application USING MSP430G2553  */
/* File generated with MSPBootVecRedGen.pl on 07-18-2017 */
/*----------------------------------------------------------------------------*/

#include "msp430.h"
#include <stdint.h>
#include "TI_MSPBoot_Mgr_Vectors.h"

// Global variables
/*! Password sent by Application to force boot mode. This variable is in a fixed
    location and should keep same functionality and location in Boot and App */
extern uint16_t  PassWd;

/*! Status and Control byte. This variable is in a fixed
    location and should keep same functionality and location in Boot and App */
extern uint8_t  StatCtrl;

/******************************************************************************
 *
 * @brief   Forces Boot mode
 *  Sets a bit in Status and Control byte to request Boot mode, writes a password
 *  in PassWd and forces a PUC reset
 *  Boot will start execution after PUC and detect forced Boot mode
 *
 * @return  none
 *****************************************************************************/
void TI_MSPBoot_JumpToBoot( void )
{
    PassWd = BSL_PASSWORD;      // Send password
    StatCtrl |= BOOT_APP_REQ;   // Set flag to request boot mode
   __disable_interrupt();      // Disable all interrupts
    WDTCTL = WDT_MRST_0_064;    // Set watchdog and wait for expiration
    while (1);
}

//
//  External ISR prototypes used by ProxyVectorTable
//  Add your own ISRs as shown below
//
extern __interrupt void Dummy_Isr (void);
extern __interrupt void P1_Isr (void);
extern __interrupt void Timer_A (void);

//
//  Constant tables
//
/*! This is a "proxy" interrupt table which is used by the bootloader to jump to
    each interrupt routine.
    It always resides in the same location.
    It contains a BRA instruction (0x4030) followed by the address of each
    vector routine.
    Unimplemented vectors are removed (and unused vectors can be removed too)
    to save flash space
*/
//TODO: Update with the interrupt vectors used in your application, see examples
#pragma DATA_SECTION(ProxyVectorTable, ".APP_PROXY_VECTORS")
#pragma RETAIN(ProxyVectorTable)
const uint16_t ProxyVectorTable[] =
{
    /*0x4030, (uint16_t) Dummy_Isr,           // APP_PROXY_VECTOR(0)  TRAPINT
    0x4030, (uint16_t) P1_Isr,              // APP_PROXY_VECTOR(1)  PORT1
    0x4030, (uint16_t) Dummy_Isr,           // APP_PROXY_VECTOR(2)  PORT2
    0x4030, (uint16_t) Dummy_Isr,           // APP_PROXY_VECTOR(3)  ADC10
    0x4030, (uint16_t) Dummy_Isr,           // APP_PROXY_VECTOR(4)  USCIAB0TX
    0x4030, (uint16_t) Dummy_Isr,           // APP_PROXY_VECTOR(5)  USCIAB0RX
    0x4030, (uint16_t) Dummy_Isr,           // APP_PROXY_VECTOR(6)  TIMER0_A1
    0x4030, (uint16_t) Timer_A,             // APP_PROXY_VECTOR(7)  TIMER0_A0
    0x4030, (uint16_t) Dummy_Isr,           // APP_PROXY_VECTOR(8)  WDT
    0x4030, (uint16_t) Dummy_Isr,           // APP_PROXY_VECTOR(9)  COMPARATORA
    0x4030, (uint16_t) Dummy_Isr,           // APP_PROXY_VECTOR(10)  TIMER1_A1
    0x4030, (uint16_t) Dummy_Isr,           // APP_PROXY_VECTOR(11)  TIMER1_A0
    0x4030, (uint16_t) Dummy_Isr,  */         // APP_PROXY_VECTOR(12)  NMI

        // Interrupt vector as per MSP430F47177
        0x4030, (uint16_t) Dummy_Isr,           // APP_PROXY_VECTOR(0) DMA
        0x4030, (uint16_t) Dummy_Isr,           // APP_PROXY_VECTOR(1) RTC
        0x4030, (uint16_t) Dummy_Isr,           // APP_PROXY_VECTOR(2) PORT P2
        0x4030, (uint16_t) Dummy_Isr,  			// APP_PROXY_VECTOR(3) UCA1TXIFG
        0x4030, (uint16_t) Dummy_Isr,           // APP_PROXY_VECTOR(4) UCA1RXIFG
        0x4030, (uint16_t) P1_Isr,           	// APP_PROXY_VECTOR(5) PORT P1
        0x4030, (uint16_t) Dummy_Isr,           // APP_PROXY_VECTOR(6) Timer_A3
        0x4030, (uint16_t) Timer_A,             // APP_PROXY_VECTOR(7) Timer_A3
        0x4030, (uint16_t) Dummy_Isr,           // APP_PROXY_VECTOR(8) SD16_A
        0x4030, (uint16_t) Dummy_Isr,           // APP_PROXY_VECTOR(9) UCA0TXIFG
        0x4030, (uint16_t) Dummy_Isr,           // APP_PROXY_VECTOR(10) UCA0RXIFG
        0x4030, (uint16_t) Dummy_Isr,           // APP_PROXY_VECTOR(11) WDTIFG
        0x4030, (uint16_t) Dummy_Isr,           // APP_PROXY_VECTOR(12) CAIFG
        0x4030, (uint16_t) Dummy_Isr,           // APP_PROXY_VECTOR(13) Timer_B3
        0x4030, (uint16_t) Dummy_Isr,           // APP_PROXY_VECTOR(14) Timer_B3
        0x4030, (uint16_t) Dummy_Isr,           // APP_PROXY_VECTOR(15) NMI
};




